<?php

namespace App\Libraries;

use CodeIgniter\HTTP\Client;

class PanelAPI{
    
    protected $apiHost;
    protected $apiHeader;
    protected $client;
    
    private const HELPER_WEB_DETAILS = 'web_details';
    private const HELPER_HOME = 'get_home';
    private const HELPER_SIDEBAR = 'get_sidebar';
    private const HELPER_RADIOS = 'get_radios';
    private const HELPER_CATEGORY = 'get_category';
    private const HELPER_COUNTRIES = 'get_countries';
    private const HELPER_PODCASTS = 'get_podcasts';
    private const HELPER_CAT_RADIO = 'get_cat_radio';
    private const HELPER_COUNTRIES_RADIO = 'get_countries_radio';
    private const HELPER_BANNER_RADIO = 'get_banner_radio';
    private const HELPER_SINGLE_RADIO = 'get_single_radio';
    private const HELPER_PODCAST_BY = 'get_podcast_by';
    private const HELPER_SEARCH_RADIO = 'get_search_radio';
    private const HELPER_USER_LOGIN = 'user_login';
    private const HELPER_NOTIFICATON = 'get_notification';
    private const HELPER_NOTIFICATON_CLEAR = 'clear_notification';
    private const HELPER_SUGGESTION = 'post_suggest';
    private const HELPER_REGISTOR = 'user_register';
    private const HELPER_PROFILE_UPDATE = 'profile_update';
    
    public function __construct(){
        $this->apiHost  = getenv('ADMIN_PANEL_URL');
        $this->apiHeader = getenv('API_HEADER');
        $this->client = \Config\Services::curlrequest();
    }

    // API Request
    private function getAPIRequest(array $data = []){
        try {
            $response = $this->client->request('POST', $this->apiHost . "api-web", [
                'form_params' => $data,
                'timeout' => 30
            ]);
            return json_decode($response->getBody(), true);
        } catch (\Exception $e) {
            return false;
        }
    }
    
    public function getWebDetails(){
        $data = ['helper_name' => self::HELPER_WEB_DETAILS];
        $response = $this->getAPIRequest($data);
        return $this->extractResponse($response);
    }
    
    public function getHome(){
        $data = ['helper_name' => self::HELPER_HOME];
        $response = $this->getAPIRequest($data);
        return $this->extractResponse($response);
    }
    
    public function getSidebar(){
        $data = ['helper_name' => self::HELPER_SIDEBAR];
        $response = $this->getAPIRequest($data);
        return $this->extractResponse($response);
    }

    public function getRadios(){
        $data = ['helper_name' => self::HELPER_RADIOS];
        $response = $this->getAPIRequest($data);
        return $this->extractResponse($response);
    }

    public function getCategory(){
        $data = ['helper_name' => self::HELPER_CATEGORY];
        $response = $this->getAPIRequest($data);
        return $this->extractResponse($response);
    }
    
    public function getCountries(){
        $data = ['helper_name' => self::HELPER_COUNTRIES];
        $response = $this->getAPIRequest($data);
        return $this->extractResponse($response);
    }

    public function getPodcast(){
        $data = ['helper_name' => self::HELPER_PODCASTS];
        $response = $this->getAPIRequest($data);
        return $this->extractResponse($response);
    }

    public function getCategoriesBy($id = 0){
        $data = [
            'helper_name' => self::HELPER_CAT_RADIO,
            'cat_id' => $id
        ];
        $response = $this->getAPIRequest($data);
        return $this->extractResponse($response);
    }

    public function getCountriesBy($id = 0){
        $data = [
            'helper_name' => self::HELPER_COUNTRIES_RADIO,
            'countries_id' => $id
        ];
        $response = $this->getAPIRequest($data);
        return $this->extractResponse($response);
    }
    
    public function getBannerBy($id = 0){
        $data = [
            'helper_name' => self::HELPER_BANNER_RADIO,
            'banner_id' => $id
        ];
        $response = $this->getAPIRequest($data);
        return $this->extractResponse($response);
    }

    public function getRadioId($id = 0){
        $data = [
            'helper_name' => self::HELPER_SINGLE_RADIO,
            'radio_id' => $id
        ];
        $response = $this->getAPIRequest($data);
        return $this->extractResponse($response);
    }

    public function getPodcastBy($id = 0){
        $data = [
            'helper_name' => self::HELPER_PODCAST_BY,
            'podcast_id' => $id
        ];
        $response = $this->getAPIRequest($data);
        return $this->extractResponse($response);
    }

    public function getSearch($search = 0){
        $data = [
            'helper_name' => self::HELPER_SEARCH_RADIO,
            'search_text' => $search
        ];
        $response = $this->getAPIRequest($data);
        return $this->extractResponse($response);
    }

    public function getUserLogin($user_email, $password){
        $data = [
            'helper_name' => self::HELPER_USER_LOGIN,
            'user_email' => $user_email,
            'user_password' => $password
        ];
        $response = $this->getAPIRequest($data);
        return $this->extractResponse($response);
    }

    public function getUserNotification($user_id){
        $data = [
            'helper_name' => self::HELPER_NOTIFICATON,
            'user_id' => $user_id
        ];
        $response = $this->getAPIRequest($data);
        return $this->extractResponse($response);
    }

    public function clearNotification($user_id){
        $data = [
            'helper_name' => self::HELPER_NOTIFICATON_CLEAR,
            'user_id' => $user_id
        ];
        $response = $this->getAPIRequest($data);
        return $this->extractResponse($response);
    }
    
    public function addSuggestion($user_id, $suggest_title, $suggest_message){
        $data = [
            'helper_name' => self::HELPER_SUGGESTION,
            'user_id' => $user_id,
            'suggest_title' => $suggest_title,
            'suggest_message' => $suggest_message
        ];
        $response = $this->getAPIRequest($data);
        return $this->extractResponse($response);
    }
    
    public function setRegister($user_email, $user_name, $user_phone, $user_pass, $user_gender){
        $data = [
            'helper_name' => self::HELPER_REGISTOR,
            'user_email' => $user_email,
            'user_name' => $user_name,
            'user_phone' => $user_phone,
            'user_password' => $user_pass,
            'user_gender' => $user_gender
        ];
        $response = $this->getAPIRequest($data);
        return $this->extractResponse($response);
    }
    
    
    public function setProfileUpdate($user_id, $user_email, $user_name, $user_phone, $user_gender){
       $data = [
            'helper_name' => self::HELPER_PROFILE_UPDATE,
            'user_id' => $user_id,
            'user_email' => $user_email,
            'user_name' => $user_name,
            'user_phone' => $user_phone,
            'user_gender' => $user_gender
        ];
        $response = $this->getAPIRequest($data);
        return $this->extractResponse($response); 
    }
    
    public function setPasswordUpdate($user_id, $user_pass){
       $data = [
            'helper_name' => self::HELPER_PROFILE_UPDATE,
            'user_id' => $user_id,
            'user_password' => $user_pass
        ];
        $response = $this->getAPIRequest($data);
        return $this->extractResponse($response); 
    }
    
    private function extractResponse($response){
        return !empty($response[$this->apiHeader]) ? $response[$this->apiHeader] : false;
    }
}